/*
 * Decompiled with CFR 0.152.
 */
package rs117.hd.data;

import java.util.function.Consumer;
import rs117.hd.data.materials.Material;
import rs117.hd.utils.HDUtils;

public enum WaterType {
    NONE,
    WATER,
    WATER_FLAT(WATER, true),
    SWAMP_WATER(b -> b.specularStrength(0.1f).specularGloss(100.0f).normalStrength(0.05f).baseOpacity(0.8f).fresnelAmount(0.3f).surfaceColor(HDUtils.linearToSrgb(HDUtils.rgb(23, 33, 20))).foamColor(HDUtils.linearToSrgb(HDUtils.rgb(115, 120, 101))).depthColor(HDUtils.linearToSrgb(HDUtils.rgb(41, 82, 26))).causticsStrength(0.0f).duration(1.2f)),
    SWAMP_WATER_FLAT(SWAMP_WATER, true),
    POISON_WASTE(b -> b.specularStrength(0.1f).specularGloss(100.0f).normalStrength(0.05f).baseOpacity(0.9f).fresnelAmount(0.3f).surfaceColor(HDUtils.linearToSrgb(HDUtils.rgb(22, 23, 13))).foamColor(HDUtils.linearToSrgb(HDUtils.rgb(106, 108, 100))).depthColor(HDUtils.linearToSrgb(HDUtils.rgb(50, 52, 46))).causticsStrength(0.0f).duration(1.6f)),
    POISON_WASTE_FLAT(POISON_WASTE, true),
    BLOOD(b -> b.specularStrength(0.5f).specularGloss(500.0f).normalStrength(0.05f).baseOpacity(0.8f).fresnelAmount(0.3f).surfaceColor(HDUtils.linearToSrgb(HDUtils.rgb(38, 0, 0))).foamColor(HDUtils.linearToSrgb(HDUtils.rgb(117, 63, 45))).depthColor(HDUtils.linearToSrgb(HDUtils.rgb(50, 26, 22))).causticsStrength(0.0f).duration(2.0f)),
    ICE(b -> b.specularStrength(0.3f).specularGloss(200.0f).normalStrength(0.04f).baseOpacity(0.85f).fresnelAmount(1.0f).foamColor(HDUtils.linearToSrgb(HDUtils.rgb(150, 150, 150))).depthColor(HDUtils.linearToSrgb(HDUtils.rgb(0, 117, 142))).causticsStrength(0.4f).duration(0.0f).normalMap(Material.WATER_NORMAL_MAP_2)),
    ICE_FLAT(ICE, true);

    public final boolean flat;
    public final float specularStrength;
    public final float specularGloss;
    public final float normalStrength;
    public final float baseOpacity;
    public final float fresnelAmount;
    public final Material normalMap;
    public final float[] surfaceColor;
    public final float[] foamColor;
    public final float[] depthColor;
    public final float causticsStrength;
    public final boolean hasFoam;
    public final float duration;

    private WaterType() {
        this(b -> {});
    }

    private WaterType(Consumer<Builder> consumer) {
        Builder builder = new Builder();
        consumer.accept(builder);
        this.flat = builder.flat;
        this.specularStrength = builder.specularStrength;
        this.specularGloss = builder.specularGloss;
        this.normalStrength = builder.normalStrength;
        this.baseOpacity = builder.baseOpacity;
        this.fresnelAmount = builder.fresnelAmount;
        this.normalMap = builder.normalMap;
        this.surfaceColor = builder.surfaceColor;
        this.foamColor = builder.foamColor;
        this.depthColor = builder.depthColor;
        this.causticsStrength = builder.causticsStrength;
        this.hasFoam = builder.hasFoam;
        this.duration = builder.duration;
    }

    private WaterType(WaterType parent, boolean flat) {
        this.flat = flat;
        this.specularStrength = parent.specularStrength;
        this.specularGloss = parent.specularGloss;
        this.normalStrength = parent.normalStrength;
        this.baseOpacity = parent.baseOpacity;
        this.fresnelAmount = parent.fresnelAmount;
        this.normalMap = parent.normalMap;
        this.surfaceColor = parent.surfaceColor;
        this.foamColor = parent.foamColor;
        this.depthColor = parent.depthColor;
        this.causticsStrength = parent.causticsStrength;
        this.hasFoam = parent.hasFoam;
        this.duration = parent.duration;
    }

    private static class Builder {
        private boolean flat = false;
        private float specularStrength = 0.5f;
        private float specularGloss = 500.0f;
        private float normalStrength = 0.09f;
        private float baseOpacity = 0.5f;
        private float fresnelAmount = 1.0f;
        private Material normalMap = Material.WATER_NORMAL_MAP_1;
        private float[] surfaceColor = new float[]{1.0f, 1.0f, 1.0f};
        private float[] foamColor = HDUtils.linearToSrgb(HDUtils.rgb(176, 164, 146));
        private float[] depthColor = HDUtils.linearToSrgb(HDUtils.rgb(0, 117, 142));
        private float causticsStrength = 1.0f;
        private boolean hasFoam = true;
        private float duration = 1.0f;

        private Builder() {
        }

        public Builder flat(boolean flat) {
            this.flat = flat;
            return this;
        }

        public Builder specularStrength(float specularStrength) {
            this.specularStrength = specularStrength;
            return this;
        }

        public Builder specularGloss(float specularGloss) {
            this.specularGloss = specularGloss;
            return this;
        }

        public Builder normalStrength(float normalStrength) {
            this.normalStrength = normalStrength;
            return this;
        }

        public Builder baseOpacity(float baseOpacity) {
            this.baseOpacity = baseOpacity;
            return this;
        }

        public Builder fresnelAmount(float fresnelAmount) {
            this.fresnelAmount = fresnelAmount;
            return this;
        }

        public Builder normalMap(Material normalMap) {
            this.normalMap = normalMap;
            return this;
        }

        public Builder surfaceColor(float[] surfaceColor) {
            this.surfaceColor = surfaceColor;
            return this;
        }

        public Builder foamColor(float[] foamColor) {
            this.foamColor = foamColor;
            return this;
        }

        public Builder depthColor(float[] depthColor) {
            this.depthColor = depthColor;
            return this;
        }

        public Builder causticsStrength(float causticsStrength) {
            this.causticsStrength = causticsStrength;
            return this;
        }

        public Builder hasFoam(boolean hasFoam) {
            this.hasFoam = hasFoam;
            return this;
        }

        public Builder duration(float duration) {
            this.duration = duration;
            return this;
        }
    }
}

