/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.utils.icon;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.api.colorscheme.SubstanceColorScheme;
import org.pushingpixels.substance.api.icon.SubstanceIconUIResource;
import org.pushingpixels.substance.internal.animation.StateTransitionTracker;
import org.pushingpixels.substance.internal.utils.HashMapKey;
import org.pushingpixels.substance.internal.utils.LazyResettableHashMap;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;
import org.pushingpixels.substance.internal.utils.icon.TransitionAware;
import org.pushingpixels.substance.internal.utils.icon.TransitionAwareIcon;

@TransitionAware
public class HighlightableTransitionAwareIcon
implements Icon {
    private static LazyResettableHashMap<SubstanceIconUIResource> iconMap = new LazyResettableHashMap("HighlightableTransitionAwareIcon");
    private int iconWidth;
    private int iconHeight;
    private TransitionAwareIcon.Delegate delegate;
    private JComponent component;
    private SubstanceSlices.ComponentStateFacet facetForHighlights;
    private TransitionAwareIcon.TransitionAwareUIDelegate transitionAwareUIDelegate;
    private String uniqueIconTypeId;

    public HighlightableTransitionAwareIcon(JComponent component, TransitionAwareIcon.TransitionAwareUIDelegate transitionAwareUIDelegate, TransitionAwareIcon.Delegate delegate, SubstanceSlices.ComponentStateFacet facetForHighlights, String uniqueIconTypeId) {
        this.component = component;
        this.facetForHighlights = facetForHighlights;
        this.transitionAwareUIDelegate = transitionAwareUIDelegate;
        this.delegate = delegate;
        this.uniqueIconTypeId = uniqueIconTypeId;
        SubstanceIconUIResource enabledIcon = this.delegate.getColorSchemeIcon(SubstanceColorSchemeUtilities.getColorScheme(component, ComponentState.ENABLED));
        this.iconWidth = enabledIcon.getIconWidth();
        this.iconHeight = enabledIcon.getIconHeight();
    }

    @Override
    public void paintIcon(Component c, Graphics g2, int x, int y) {
        this.getIconToPaint().paintIcon(c, g2, x, y);
    }

    private SubstanceIconUIResource getIconToPaint() {
        StateTransitionTracker stateTransitionTracker = this.transitionAwareUIDelegate.getTransitionAwareUI().getTransitionTracker();
        StateTransitionTracker.ModelStateInfo modelStateInfo = stateTransitionTracker.getModelStateInfo();
        Map<ComponentState, StateTransitionTracker.StateContributionInfo> activeStates = modelStateInfo.getStateNoSelectionContributionMap();
        ComponentState currState = modelStateInfo.getCurrModelStateNoSelection();
        SubstanceSlices.ColorSchemeAssociationKind baseAssociationKind = currState.isFacetActive(this.facetForHighlights) ? SubstanceSlices.ColorSchemeAssociationKind.HIGHLIGHT : SubstanceSlices.ColorSchemeAssociationKind.MARK;
        SubstanceColorScheme baseScheme = SubstanceColorSchemeUtilities.getColorScheme(this.component, baseAssociationKind, currState);
        float baseAlpha = SubstanceColorSchemeUtilities.getAlpha(this.component, currState);
        HashMapKey keyBase = SubstanceCoreUtilities.getHashKey(this.component.getClass().getName(), this.uniqueIconTypeId, SubstanceSizeUtils.getComponentFontSize(this.component), baseScheme.getDisplayName(), Float.valueOf(baseAlpha));
        SubstanceIconUIResource layerBase = iconMap.get(keyBase);
        if (layerBase == null) {
            SubstanceIconUIResource baseFullOpacity = this.delegate.getColorSchemeIcon(baseScheme);
            if (baseAlpha == 1.0f) {
                layerBase = baseFullOpacity;
                iconMap.put(keyBase, layerBase);
            } else {
                BufferedImage baseImage = SubstanceCoreUtilities.getBlankImage(baseFullOpacity.getIconWidth(), baseFullOpacity.getIconHeight());
                Graphics2D g2base = baseImage.createGraphics();
                g2base.setComposite(AlphaComposite.SrcOver.derive(baseAlpha));
                baseFullOpacity.paintIcon(this.component, g2base, 0, 0);
                g2base.dispose();
                layerBase = new SubstanceIconUIResource(baseImage);
                iconMap.put(keyBase, layerBase);
            }
        }
        if (currState.isDisabled() || activeStates.size() == 1) {
            return layerBase;
        }
        BufferedImage result = SubstanceCoreUtilities.getBlankImage(layerBase.getIconWidth(), layerBase.getIconHeight());
        Graphics2D g2d = result.createGraphics();
        layerBase.paintIcon(this.component, g2d, 0, 0);
        for (Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo> activeEntry : activeStates.entrySet()) {
            float stateContribution;
            ComponentState activeState = activeEntry.getKey();
            if (activeState == currState || !((stateContribution = activeEntry.getValue().getContribution()) > 0.0f)) continue;
            g2d.setComposite(AlphaComposite.SrcOver.derive(stateContribution));
            SubstanceSlices.ColorSchemeAssociationKind associationKind = activeState.isFacetActive(this.facetForHighlights) ? SubstanceSlices.ColorSchemeAssociationKind.HIGHLIGHT : SubstanceSlices.ColorSchemeAssociationKind.MARK;
            SubstanceColorScheme scheme = SubstanceColorSchemeUtilities.getColorScheme(this.component, associationKind, activeState);
            float alpha = SubstanceColorSchemeUtilities.getAlpha(this.component, activeState);
            HashMapKey key = SubstanceCoreUtilities.getHashKey(this.component.getClass().getName(), this.uniqueIconTypeId, SubstanceSizeUtils.getComponentFontSize(this.component), scheme.getDisplayName(), Float.valueOf(alpha));
            SubstanceIconUIResource layer = iconMap.get(key);
            if (layer == null) {
                SubstanceIconUIResource fullOpacity = this.delegate.getColorSchemeIcon(scheme);
                if (alpha == 1.0f) {
                    layer = fullOpacity;
                    iconMap.put(key, layer);
                } else {
                    BufferedImage image = SubstanceCoreUtilities.getBlankImage(fullOpacity.getIconWidth(), fullOpacity.getIconHeight());
                    Graphics2D g2layer = image.createGraphics();
                    g2layer.setComposite(AlphaComposite.SrcOver.derive(alpha));
                    fullOpacity.paintIcon(this.component, g2layer, 0, 0);
                    g2layer.dispose();
                    layer = new SubstanceIconUIResource(image);
                    iconMap.put(key, layer);
                }
            }
            layer.paintIcon(this.component, g2d, 0, 0);
        }
        g2d.dispose();
        return new SubstanceIconUIResource(result);
    }

    @Override
    public int getIconHeight() {
        return this.iconHeight;
    }

    @Override
    public int getIconWidth() {
        return this.iconWidth;
    }
}

