/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.painter;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSpinner;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.pushingpixels.substance.api.SubstanceCortex;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.api.watermark.SubstanceWatermark;
import org.pushingpixels.substance.internal.painter.DecorationPainterUtils;
import org.pushingpixels.substance.internal.painter.OverlayPainterUtils;
import org.pushingpixels.substance.internal.utils.SubstanceColorUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.WidgetUtilities;

public class BackgroundPaintingUtils {
    public static void updateIfOpaque(Graphics g2, JComponent c) {
        if (SubstanceCoreUtilities.isOpaque(c)) {
            BackgroundPaintingUtils.update(g2, c, false);
        }
    }

    public static void update(Graphics g2, JComponent c, boolean force) {
        if (!SubstanceCoreUtilities.isCurrentLookAndFeel()) {
            return;
        }
        boolean isInCellRenderer = SwingUtilities.getAncestorOfClass(CellRendererPane.class, c) != null;
        boolean isPreviewMode = Boolean.TRUE.equals(c.getClientProperty("substance.widget.internal.previewMode"));
        Graphics2D graphics = (Graphics2D)g2.create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        graphics.setComposite(WidgetUtilities.getAlphaComposite((Component)c, g2));
        SubstanceSlices.DecorationAreaType decorationType = SubstanceCortex.ComponentOrParentChainScope.getDecorationType(c);
        SubstanceSkin skin = SubstanceCoreUtilities.getSkin(c);
        boolean isShowing = c.isShowing();
        if (isShowing && decorationType != SubstanceSlices.DecorationAreaType.NONE && skin.isRegisteredAsDecorationArea(decorationType)) {
            DecorationPainterUtils.paintDecorationBackground(graphics, c, force);
            boolean showOverlays = true;
            if (c.getParent() instanceof JPopupMenu) {
                showOverlays = false;
            } else if (c instanceof JMenuItem) {
                showOverlays = false;
                if (c instanceof JMenu) {
                    showOverlays = ((JMenu)c).isTopLevelMenu();
                }
            } else if (c instanceof JMenuBar) {
                showOverlays = true;
            }
            if (showOverlays) {
                OverlayPainterUtils.paintOverlays(graphics, c, skin, decorationType);
            }
        } else {
            Color backgr = SubstanceColorUtilities.getBackgroundFillColor(c instanceof JTextComponent || c instanceof JSpinner ? c.getParent() : c);
            graphics.setColor(backgr);
            graphics.fillRect(0, 0, c.getWidth(), c.getHeight());
            if (isShowing) {
                OverlayPainterUtils.paintOverlays(graphics, c, skin, decorationType);
                SubstanceWatermark watermark = SubstanceCoreUtilities.getSkin(c).getWatermark();
                if (watermark != null && !isPreviewMode && !isInCellRenderer && SubstanceCoreUtilities.toDrawWatermark(c)) {
                    watermark.drawWatermarkImage(graphics, c, 0, 0, c.getWidth(), c.getHeight());
                }
            }
        }
        graphics.dispose();
    }

    public static void fillAndWatermark(Graphics g2, JComponent c, Color fillColor, Rectangle rect) {
        boolean isInCellRenderer;
        if (!SubstanceCoreUtilities.isCurrentLookAndFeel()) {
            return;
        }
        boolean bl = isInCellRenderer = SwingUtilities.getAncestorOfClass(CellRendererPane.class, c) != null;
        if (!c.isShowing() && !isInCellRenderer) {
            return;
        }
        Graphics2D graphics = (Graphics2D)g2.create();
        graphics.setComposite(WidgetUtilities.getAlphaComposite((Component)c, g2));
        graphics.setColor(fillColor);
        graphics.fillRect(rect.x, rect.y, rect.width, rect.height);
        graphics.setComposite(WidgetUtilities.getAlphaComposite(c, 1.0f, g2));
        SubstanceWatermark watermark = SubstanceCoreUtilities.getSkin(c).getWatermark();
        if (watermark != null && !isInCellRenderer && c.isShowing() && SubstanceCoreUtilities.toDrawWatermark(c)) {
            watermark.drawWatermarkImage(graphics, c, rect.x, rect.y, rect.width, rect.height);
        }
        graphics.dispose();
    }
}

