/*
 * Decompiled with CFR 0.152.
 */
package org.pf4j.update.verifier;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.pf4j.update.FileVerifier;
import org.pf4j.update.VerifyException;
import org.pf4j.update.verifier.BasicVerifier;
import org.pf4j.update.verifier.Sha512SumVerifier;

public class CompoundVerifier
implements FileVerifier {
    public static final List<FileVerifier> ALL_DEFAULT_FILE_VERIFIERS = Arrays.asList(new BasicVerifier(), new Sha512SumVerifier());
    private List<FileVerifier> verifiers = new ArrayList<FileVerifier>();

    public CompoundVerifier() {
        this.setVerifiers(ALL_DEFAULT_FILE_VERIFIERS);
    }

    public CompoundVerifier(List<FileVerifier> verifiers) {
        this.verifiers = verifiers;
    }

    @Override
    public void verify(FileVerifier.Context context, Path file) throws IOException, VerifyException {
        for (FileVerifier verifier : this.getVerifiers()) {
            verifier.verify(context, file);
        }
    }

    public List<FileVerifier> getVerifiers() {
        return this.verifiers;
    }

    public void setVerifiers(List<FileVerifier> verifiers) {
        this.verifiers = verifiers;
    }
}

