/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.combatlevel;

import com.google.common.annotations.VisibleForTesting;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Experience;
import net.runelite.api.Skill;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.plugins.combatlevel.CombatLevelConfig;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.tooltip.Tooltip;
import net.runelite.client.ui.overlay.tooltip.TooltipManager;
import net.runelite.client.util.ColorUtil;

class CombatLevelOverlay
extends Overlay {
    private static final Color COMBAT_LEVEL_COLOUR = new Color(16750623);
    private final Client client;
    private final CombatLevelConfig config;
    private final TooltipManager tooltipManager;

    @Inject
    private CombatLevelOverlay(Client client, CombatLevelConfig config, TooltipManager tooltipManager) {
        this.client = client;
        this.config = config;
        this.tooltipManager = tooltipManager;
    }

    @Override
    public Dimension render(Graphics2D graphics) {
        Widget combatLevelWidget = this.client.getWidget(WidgetInfo.COMBAT_LEVEL);
        if (!this.config.showLevelsUntil() || this.client.getLocalPlayer().getCombatLevel() == 126 || combatLevelWidget == null || combatLevelWidget.isHidden()) {
            return null;
        }
        Rectangle combatCanvas = combatLevelWidget.getBounds();
        if (combatCanvas == null) {
            return null;
        }
        if (combatCanvas.contains(this.client.getMouseCanvasPosition().getX(), this.client.getMouseCanvasPosition().getY())) {
            this.tooltipManager.add(new Tooltip(this.getLevelsUntilTooltip()));
        }
        return null;
    }

    @VisibleForTesting
    String getLevelsUntilTooltip() {
        int attackLevel = this.client.getRealSkillLevel(Skill.ATTACK);
        int strengthLevel = this.client.getRealSkillLevel(Skill.STRENGTH);
        int defenceLevel = this.client.getRealSkillLevel(Skill.DEFENCE);
        int hitpointsLevel = this.client.getRealSkillLevel(Skill.HITPOINTS);
        int magicLevel = this.client.getRealSkillLevel(Skill.MAGIC);
        int rangeLevel = this.client.getRealSkillLevel(Skill.RANGED);
        int prayerLevel = this.client.getRealSkillLevel(Skill.PRAYER);
        int meleeNeed = Experience.getNextCombatLevelMelee(attackLevel, strengthLevel, defenceLevel, hitpointsLevel, magicLevel, rangeLevel, prayerLevel);
        int hpDefNeed = Experience.getNextCombatLevelHpDef(attackLevel, strengthLevel, defenceLevel, hitpointsLevel, magicLevel, rangeLevel, prayerLevel);
        int rangeNeed = Experience.getNextCombatLevelRange(attackLevel, strengthLevel, defenceLevel, hitpointsLevel, magicLevel, rangeLevel, prayerLevel);
        int magicNeed = Experience.getNextCombatLevelMagic(attackLevel, strengthLevel, defenceLevel, hitpointsLevel, magicLevel, rangeLevel, prayerLevel);
        int prayerNeed = Experience.getNextCombatLevelPrayer(attackLevel, strengthLevel, defenceLevel, hitpointsLevel, magicLevel, rangeLevel, prayerLevel);
        StringBuilder sb = new StringBuilder();
        sb.append(ColorUtil.wrapWithColorTag("Next combat level:</br>", COMBAT_LEVEL_COLOUR));
        if (attackLevel + strengthLevel < 198) {
            sb.append(meleeNeed).append(" Attack/Strength</br>");
        }
        if (hitpointsLevel + defenceLevel < 198) {
            sb.append(hpDefNeed).append(" Defence/Hitpoints</br>");
        }
        if (rangeLevel < 99) {
            sb.append(rangeNeed).append(" Ranged</br>");
        }
        if (magicLevel < 99) {
            sb.append(magicNeed).append(" Magic</br>");
        }
        if (prayerLevel < 99) {
            sb.append(prayerNeed).append(" Prayer");
        }
        return sb.toString();
    }
}

