/*
 * Decompiled with CFR 0.152.
 */
package com.visualmetronome;

import com.google.inject.Provides;
import com.visualmetronome.FullResizableVisualMetronomeOverlay;
import com.visualmetronome.VisualMetronomeConfig;
import com.visualmetronome.VisualMetronomeTileOverlay;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.KeyEvent;
import javax.inject.Inject;
import net.runelite.api.events.GameTick;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.input.KeyListener;
import net.runelite.client.input.KeyManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.OverlayManager;

@PluginDescriptor(name="Visual Metronome", description="Shows a visual cue on an overlay every game tick to help timing based activities", tags={"timers", "overlays", "tick", "skilling"}, enabledByDefault=false)
public class VisualMetronomePlugin
extends Plugin
implements KeyListener {
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private ConfigManager configManager;
    @Inject
    private VisualMetronomeTileOverlay tileOverlay;
    @Inject
    private FullResizableVisualMetronomeOverlay overlay;
    @Inject
    private VisualMetronomeConfig config;
    @Inject
    private KeyManager keyManager;
    protected int currentColorIndex = 0;
    protected int tickCounter = 0;
    protected Color currentColor = Color.WHITE;
    protected Dimension DEFAULT_SIZE = new Dimension(25, 25);

    @Provides
    VisualMetronomeConfig provideConfig(ConfigManager configManager) {
        return configManager.getConfig(VisualMetronomeConfig.class);
    }

    @Subscribe
    public void onGameTick(GameTick tick) {
        if (this.tickCounter % this.config.tickCount() == 0) {
            this.tickCounter = 0;
            if (this.currentColorIndex == this.config.colorCycle()) {
                this.currentColorIndex = 0;
            }
            switch (++this.currentColorIndex) {
                case 1: {
                    this.currentColor = this.config.getTickColor();
                    break;
                }
                case 2: {
                    this.currentColor = this.config.getTockColor();
                    break;
                }
                case 3: {
                    this.currentColor = this.config.getTick3Color();
                    break;
                }
                case 4: {
                    this.currentColor = this.config.getTick4Color();
                    break;
                }
                case 5: {
                    this.currentColor = this.config.getTick5Color();
                    break;
                }
                case 6: {
                    this.currentColor = this.config.getTick6Color();
                    break;
                }
                case 7: {
                    this.currentColor = this.config.getTick7Color();
                    break;
                }
                case 8: {
                    this.currentColor = this.config.getTick8Color();
                    break;
                }
                case 9: {
                    this.currentColor = this.config.getTick9Color();
                    break;
                }
                case 10: {
                    this.currentColor = this.config.getTick10Color();
                }
            }
        }
        ++this.tickCounter;
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (!event.getGroup().equals("visualmetronome")) {
            return;
        }
        if (this.currentColorIndex > this.config.colorCycle()) {
            this.currentColorIndex = 0;
        }
        if (this.tickCounter > this.config.tickCount()) {
            this.tickCounter = 0;
        }
        this.DEFAULT_SIZE = new Dimension(this.config.boxWidth(), this.config.boxWidth());
    }

    @Override
    protected void startUp() throws Exception {
        this.DEFAULT_SIZE = new Dimension(this.config.boxWidth(), this.config.boxWidth());
        this.overlay.setPreferredSize(this.DEFAULT_SIZE);
        this.overlayManager.add(this.overlay);
        this.overlayManager.add(this.tileOverlay);
        this.keyManager.registerKeyListener(this);
    }

    @Override
    protected void shutDown() throws Exception {
        this.overlayManager.remove(this.overlay);
        this.overlayManager.remove(this.tileOverlay);
        this.tickCounter = 0;
        this.currentColorIndex = 0;
        this.currentColor = this.config.getTickColor();
        this.keyManager.unregisterKeyListener(this);
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (this.config.tickResetHotkey().matches(e)) {
            this.tickCounter = 0;
            this.currentColorIndex = 0;
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }
}

