/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.toa.features.scabaras.overlay;

import com.duckblade.osrs.toa.TombsOfAmascutConfig;
import com.duckblade.osrs.toa.features.scabaras.ScabarasHelperMode;
import com.duckblade.osrs.toa.features.scabaras.overlay.MatchingTile;
import com.duckblade.osrs.toa.module.PluginLifecycleComponent;
import com.duckblade.osrs.toa.util.RaidRoom;
import com.duckblade.osrs.toa.util.RaidState;
import com.google.common.collect.ImmutableMap;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameObjectSpawned;
import net.runelite.api.events.GroundObjectSpawned;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.eventbus.Subscribe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class MatchingPuzzleSolver
implements PluginLifecycleComponent {
    private static final Logger log = LoggerFactory.getLogger(MatchingPuzzleSolver.class);
    private static final Map<Integer, String> TILE_NAMES = ImmutableMap.builder().put(45365, "Line").put(45366, "Knives").put(45367, "Crook").put(45368, "Diamond").put(45369, "Hand").put(45370, "Star").put(45371, "Bird").put(45372, "W").put(45373, "Boot").build();
    private static final Map<Integer, Color> TILE_COLORS = ImmutableMap.builder().put(45365, Color.black).put(45366, Color.red).put(45367, Color.magenta).put(45368, Color.blue).put(45369, Color.lightGray).put(45370, Color.cyan).put(45371, Color.pink).put(45372, Color.yellow).put(45373, Color.green).build();
    private static final Map<Integer, Integer> MATCHED_OBJECT_IDS = ImmutableMap.builder().put(45388, 45365).put(45389, 45366).put(45386, 45367).put(45391, 45368).put(45392, 45369).put(45387, 45370).put(45393, 45371).put(45394, 45372).put(45395, 45373).build();
    private final EventBus eventBus;
    private final Map<LocalPoint, MatchingTile> discoveredTiles = new HashMap<LocalPoint, MatchingTile>(18);

    @Override
    public boolean isEnabled(TombsOfAmascutConfig config, RaidState raidState) {
        return config.scabarasHelperMode() == ScabarasHelperMode.OVERLAY && raidState.getCurrentRoom() == RaidRoom.SCABARAS;
    }

    @Override
    public void startUp() {
        this.eventBus.register(this);
        this.discoveredTiles.clear();
    }

    @Override
    public void shutDown() {
        this.eventBus.unregister(this);
    }

    @Subscribe
    public void onGroundObjectSpawned(GroundObjectSpawned e) {
        int id = e.getGroundObject().getId();
        if (TILE_COLORS.containsKey(id)) {
            LocalPoint lp = e.getGroundObject().getLocalLocation();
            this.discoveredTiles.put(lp, new MatchingTile(lp, TILE_NAMES.getOrDefault(id, "Unknown"), TILE_COLORS.getOrDefault(id, Color.black)));
        }
    }

    @Subscribe
    public void onGameObjectSpawned(GameObjectSpawned e) {
        int gameId = e.getGameObject().getId();
        if (MATCHED_OBJECT_IDS.containsKey(gameId)) {
            MatchingTile match = this.discoveredTiles.get(e.getGameObject().getLocalLocation());
            if (match == null) {
                log.debug("Failed to find discovered tile for game object id {}!", (Object)gameId);
                return;
            }
            match.setMatched(true);
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage e) {
        if (e.getMessage().startsWith("Your party failed to complete the challenge")) {
            this.discoveredTiles.clear();
        }
    }

    @Inject
    public MatchingPuzzleSolver(EventBus eventBus) {
        this.eventBus = eventBus;
    }

    public Map<LocalPoint, MatchingTile> getDiscoveredTiles() {
        return this.discoveredTiles;
    }
}

