/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.toa.features.invocationpresets;

import com.duckblade.osrs.toa.TombsOfAmascutConfig;
import com.duckblade.osrs.toa.features.invocationpresets.InvocationPreset;
import com.duckblade.osrs.toa.module.PluginLifecycleComponent;
import com.duckblade.osrs.toa.util.Invocation;
import com.duckblade.osrs.toa.util.RaidState;
import com.duckblade.osrs.toa.util.RaidStateTracker;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Runnables;
import java.awt.Color;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Consumer;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.MenuAction;
import net.runelite.api.MenuEntry;
import net.runelite.api.events.MenuEntryAdded;
import net.runelite.api.events.ScriptPostFired;
import net.runelite.api.widgets.Widget;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.chatbox.ChatboxPanelManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class InvocationPresetsManager
implements PluginLifecycleComponent {
    private static final Logger log = LoggerFactory.getLogger(InvocationPresetsManager.class);
    public static final int WIDGET_ID_INVOCATIONS_PARENT = 774;
    public static final int WIDGET_ID_INVOCATIONS_SCROLLBAR = 51;
    public static final int WIDGET_ID_INVOCATIONS_CHILD = 52;
    public static final int SCRIPT_ID_BUILD_TOA_PARTY_INTERFACE = 6729;
    public static final int SCRIPT_ID_TOA_PARTY_TOGGLE_REWARD_PANEL = 6732;
    private static final String CONFIG_KEY_PRESETS = "presets";
    private final EventBus eventBus;
    private final ConfigManager configManager;
    private final Client client;
    private final TombsOfAmascutConfig config;
    private final ClientThread clientThread;
    private final ChatboxPanelManager chatboxPanelManager;
    private final RaidStateTracker raidStateTracker;
    private Set<Invocation> activeInvocations = EnumSet.noneOf(Invocation.class);
    private InvocationPreset currentPreset = null;
    private final SortedMap<String, InvocationPreset> presets = new TreeMap(Comparator.reverseOrder());
    private String originalHeaderText = null;

    @Override
    public boolean isEnabled(TombsOfAmascutConfig config, RaidState currentState) {
        return config.invocationPresetsEnable() && currentState.isInLobby();
    }

    @Override
    public void startUp() {
        this.eventBus.register(this);
        this.loadPresets();
    }

    @Override
    public void shutDown() {
        this.eventBus.unregister(this);
    }

    @Subscribe
    public void onScriptPostFired(ScriptPostFired event) {
        if (event.getScriptId() == 6729 || event.getScriptId() == 6732) {
            this.updateCurrentActiveInvocations();
            this.displayPresetInvocations();
            this.displayPresetName();
        }
    }

    @Subscribe
    public void onMenuEntryAdded(MenuEntryAdded e) {
        if (!e.getOption().equals("Presets")) {
            return;
        }
        boolean deleteMode = this.client.isKeyPressed(81);
        this.presets.values().forEach(preset -> {
            Consumer<MenuEntry> onClick = deleteMode ? ignored -> this.confirmDeletePreset((InvocationPreset)preset) : ignored -> this.setCurrentPreset((InvocationPreset)preset);
            this.client.createMenuEntry(-1).setType(MenuAction.RUNELITE).setOption(deleteMode ? "<col=ff0000>Delete" : "Load").setTarget(preset.toStringDecorated()).onClick(onClick);
        });
        if (this.currentPreset != null) {
            this.client.createMenuEntry(-1).setType(MenuAction.RUNELITE).setOption("Export").setTarget(this.currentPreset.toStringDecorated()).onClick(ignored -> this.exportCurrentPreset());
        }
        this.client.createMenuEntry(-1).setType(MenuAction.RUNELITE).setOption("Import").setTarget("Preset").onClick(ignored -> this.importPreset());
        this.client.createMenuEntry(-1).setType(MenuAction.RUNELITE).setOption("Save").setTarget("New Preset").onClick(ignored -> this.savePreset());
    }

    private void setCurrentPreset(InvocationPreset preset) {
        this.currentPreset = preset;
        this.removePresetDisplay();
        this.displayPresetInvocations();
        this.displayPresetName();
    }

    public void addPreset(InvocationPreset preset) {
        log.debug("Saving new preset {}", (Object)preset.serialize());
        this.presets.put(preset.getName(), preset);
        this.setCurrentPreset(preset);
        this.configManager.setConfiguration("tombsofamascut", "presets." + preset.getName(), preset.serialize());
        String message = "Saved preset as " + preset.toStringDecorated() + ". Use Shift+Right-click to delete.";
        this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", message, "", false);
    }

    private void confirmDeletePreset(InvocationPreset preset) {
        this.chatboxPanelManager.openTextMenuInput("Are you sure you want to delete your preset called \"" + preset.getName() + "\"?").option("Yes", () -> this.clientThread.invoke(() -> this.deletePreset(preset))).option("No", Runnables::doNothing).build();
    }

    private void deletePreset(InvocationPreset preset) {
        log.debug("Deleting preset {}", (Object)preset.getName());
        this.configManager.unsetConfiguration("tombsofamascut", "presets." + preset.getName());
        this.presets.remove(preset.getName());
        this.setCurrentPreset(null);
    }

    private void savePreset() {
        this.chatboxPanelManager.openTextInput("Enter new preset name (or existing name to overwrite):").onDone(name -> this.clientThread.invoke(() -> this.addPreset(new InvocationPreset((String)name, this.activeInvocations)))).build();
    }

    private void loadPresets() {
        for (String key : this.configManager.getConfigurationKeys("tombsofamascut.presets")) {
            try {
                InvocationPreset prev;
                String keySuffix = key.split("\\.", 3)[2];
                String configValue = this.configManager.getConfiguration("tombsofamascut", "presets." + keySuffix);
                log.debug("Parsing preset config key = {} value = {}", (Object)keySuffix, (Object)configValue);
                InvocationPreset preset = InvocationPreset.parse(configValue);
                if (!preset.getName().equals(keySuffix)) {
                    log.warn("Mismatched key name from preset name key = {}, name = {}", (Object)key, (Object)preset.getName());
                }
                if ((prev = this.presets.put(preset.getName(), preset)) == null) continue;
                log.warn("Config contains duplicate preset name {}", (Object)preset.getName());
            }
            catch (Exception e) {
                log.error("Failed to parse ToA preset at config key {}", (Object)key, (Object)e);
            }
        }
    }

    private void importPreset() {
        String clipboardText;
        try {
            clipboardText = Toolkit.getDefaultToolkit().getSystemClipboard().getData(DataFlavor.stringFlavor).toString();
        }
        catch (UnsupportedFlavorException | IOException ex) {
            this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", "Unable to read system clipboard.", "", false);
            log.warn("error reading clipboard", ex);
            return;
        }
        try {
            InvocationPreset preset = InvocationPreset.parse(clipboardText);
            int presetCount = preset.getInvocations().size();
            this.chatboxPanelManager.openTextMenuInput("Import preset \"" + preset.getName() + "\" with " + presetCount + " invocations?").option("Yes", () -> this.clientThread.invoke(() -> this.addPreset(preset))).option("No", Runnables::doNothing).build();
        }
        catch (Exception e) {
            this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", "Clipboard does not contain a valid invocation preset.", "", false);
            log.warn("Failed to parse invocation preset", e);
        }
    }

    private void exportCurrentPreset() {
        if (this.currentPreset == null) {
            return;
        }
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(this.currentPreset.serialize()), null);
        this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", "Copied preset \"" + this.currentPreset.getName() + "\" to clipboard.", "", false);
    }

    private void updateCurrentActiveInvocations() {
        Widget parent = this.client.getWidget(774, 52);
        if (parent == null || parent.isHidden() || parent.getChildren() == null) {
            this.activeInvocations = EnumSet.noneOf(Invocation.class);
            return;
        }
        EnumSet<Invocation> activeCurrent = EnumSet.noneOf(Invocation.class);
        for (Invocation invoc : Invocation.values()) {
            Object[] ops;
            Widget invocW = parent.getChild(invoc.getWidgetIx());
            if (invocW == null || (ops = invocW.getOnOpListener()) == null || ops.length < 4 || !(ops[3] instanceof Integer) || (Integer)ops[3] != 1) continue;
            activeCurrent.add(invoc);
        }
        if (log.isDebugEnabled() && !activeCurrent.equals(this.activeInvocations)) {
            Sets.SetView<Invocation> adds = Sets.difference(activeCurrent, this.activeInvocations);
            Sets.SetView<Invocation> removes = Sets.difference(this.activeInvocations, activeCurrent);
            log.debug("Invocations changed! Add: {}, Remove: {}", (Object)adds, (Object)removes);
        }
        this.activeInvocations = activeCurrent;
    }

    private void displayPresetInvocations() {
        Widget parent = this.client.getWidget(774, 52);
        InvocationPreset preset = this.getCurrentPreset();
        if (parent == null || parent.isHidden() || parent.getChildren() == null || preset == null) {
            return;
        }
        boolean scrolled = false;
        for (Invocation invoc : Invocation.values()) {
            boolean currentState;
            Widget invocW = parent.getChild(invoc.getWidgetIx());
            boolean targetState = preset.getInvocations().contains((Object)invoc);
            boolean bl = currentState = (Integer)invocW.getOnOpListener()[3] == 1;
            if (targetState == currentState) continue;
            if (!scrolled) {
                this.scrollToInvocation(invoc);
                scrolled = true;
            }
            Color targetColor = targetState ? Color.green : Color.red;
            invocW.setFilled(false);
            invocW.setTextColor(targetColor.getRGB());
            invocW.setOpacity(0);
        }
    }

    private void displayPresetName() {
        InvocationPreset preset;
        Widget container = this.client.getWidget(774, 3);
        if (container == null || container.isHidden() || container.getChildren() == null || container.getChildren().length < 2) {
            return;
        }
        Widget title = container.getChild(1);
        if (title == null) {
            return;
        }
        if (title.getText().startsWith("Party of ")) {
            this.originalHeaderText = title.getText();
        }
        if ((preset = this.getCurrentPreset()) == null) {
            title.setText(this.originalHeaderText).setTextColor(16750623).revalidate();
            return;
        }
        boolean matching = preset.getInvocations().equals(this.getActiveInvocations());
        title.setText(preset.getName() + (matching ? "" : " !!!")).setTextColor(matching ? Color.green.getRGB() : Color.red.getRGB()).revalidate();
    }

    private void removePresetDisplay() {
        Widget parent = this.client.getWidget(774, 52);
        if (parent != null && !parent.isHidden() && parent.getChildren() != null) {
            for (int i = 0; i < parent.getChildren().length; i += 3) {
                parent.getChild(i).setOpacity(255).setTextColor(Color.WHITE.getRGB()).revalidate();
            }
        }
    }

    private void scrollToInvocation(Invocation invocation) {
        if (!this.config.invocationPresetsScroll()) {
            return;
        }
        this.clientThread.invokeLater(() -> {
            Widget invocationContainer = this.client.getWidget(774, 52);
            Widget scrollbar = this.client.getWidget(774, 51);
            if (invocationContainer == null || scrollbar == null) {
                return;
            }
            Widget invocW = invocationContainer.getChild(invocation.getWidgetIx());
            if (invocationContainer.getBounds().contains(invocW.getBounds())) {
                log.debug("{} already on screen ({} contains {})", new Object[]{invocation, invocationContainer.getBounds(), invocW.getBounds()});
                return;
            }
            int newScroll = Math.max(0, Math.min(invocationContainer.getScrollHeight(), invocW.getRelativeY() + invocW.getHeight() / 2 - invocationContainer.getHeight() / 2));
            this.client.runScript(72, scrollbar.getId(), invocationContainer.getId(), newScroll);
        });
    }

    @Inject
    public InvocationPresetsManager(EventBus eventBus, ConfigManager configManager, Client client, TombsOfAmascutConfig config, ClientThread clientThread, ChatboxPanelManager chatboxPanelManager, RaidStateTracker raidStateTracker) {
        this.eventBus = eventBus;
        this.configManager = configManager;
        this.client = client;
        this.config = config;
        this.clientThread = clientThread;
        this.chatboxPanelManager = chatboxPanelManager;
        this.raidStateTracker = raidStateTracker;
    }

    public Set<Invocation> getActiveInvocations() {
        return this.activeInvocations;
    }

    public InvocationPreset getCurrentPreset() {
        return this.currentPreset;
    }
}

