/*
 * Decompiled with CFR 0.152.
 */
package ca.gauntlet.module.maze;

import java.util.AbstractMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public enum Resource {
    TELEPORT_CRYSTAL("Teleport crystal", 23904, false),
    CORRUPTED_TELEPORT_CRYSTAL("Corrupted teleport crystal", 23858, true),
    WEAPON_FRAME("Weapon frame", 23871, false),
    CORRUPTED_WEAPON_FRAME("Weapon frame", 23834, true),
    CRYSTALLINE_BOWSTRING("Crystalline bowstring", 23869, false),
    CORRUPTED_BOWSTRING("Corrupted bowstring", 23832, true),
    CRYSTAL_SPIKE("Crystal spike", 23868, false),
    CORRUPTED_SPIKE("Corrupted spike", 23831, true),
    CRYSTAL_ORB("Crystal orb", 23870, false),
    CORRUPTED_ORB("Corrupted orb", 23833, true),
    RAW_PADDLEFISH("Raw paddlefish", 23872, "You manage to catch a fish\\.", false),
    CRYSTAL_SHARDS("Crystal shards", 23866, "You find (\\d+) crystal shards\\.", false),
    CORRUPTED_SHARDS("Corrupted shards", 23824, "You find (\\d+) corrupted shards\\.", true),
    CRYSTAL_ORE("Crystal ore", 23877, "You manage to mine some ore\\.", false),
    CORRUPTED_ORE("Corrupted ore", 23837, "You manage to mine some ore\\.", true),
    PHREN_BARK("Phren bark", 23878, "You get some bark\\.", false),
    CORRUPTED_PHREN_BARK("Phren bark", 23838, "You get some bark\\.", true),
    LINUM_TIRINUM("Linum tirinum", 23876, "You pick some fibre from the plant\\.", false),
    CORRUPTED_LINUM_TIRINUM("Linum tirinum", 23836, "You pick some fibre from the plant\\.", true),
    GRYM_LEAF("Grym leaf", 23875, "You pick a herb from the roots\\.", false),
    CORRUPTED_GRYM_LEAF("Grym leaf", 23835, "You pick a herb from the roots\\.", true);

    private static final Resource[] VALUES;
    private final String name;
    private final int itemId;
    private final Pattern pattern;
    private final boolean corrupted;

    private Resource(String name, int itemId, String pattern, boolean corrupted) {
        this.name = name;
        this.itemId = itemId;
        this.corrupted = corrupted;
        this.pattern = pattern != null ? Pattern.compile(pattern) : null;
    }

    private Resource(String name, int itemId, boolean corrupted) {
        this(name, itemId, null, corrupted);
    }

    static Resource fromName(String name, boolean corrupted) {
        for (Resource resource : VALUES) {
            if (resource.corrupted != corrupted && resource != RAW_PADDLEFISH || !resource.name.equals(name)) continue;
            return resource;
        }
        return null;
    }

    static Map.Entry<Resource, Integer> fromPattern(String pattern, boolean corrupted) {
        for (Resource resource : VALUES) {
            Matcher matcher;
            if (resource.pattern == null || corrupted != resource.corrupted && resource != RAW_PADDLEFISH || !(matcher = resource.pattern.matcher(pattern)).matches()) continue;
            int itemCount = matcher.groupCount() == 1 ? Integer.parseInt(matcher.group(1)) : 1;
            return new AbstractMap.SimpleImmutableEntry<Resource, Integer>(resource, itemCount);
        }
        return null;
    }

    public String toString() {
        return this.name;
    }

    int getItemId() {
        return this.itemId;
    }

    static {
        VALUES = Resource.values();
    }
}

