/*
 * Decompiled with CFR 0.152.
 */
package ca.gauntlet;

import ca.gauntlet.TheGauntletConfig;
import ca.gauntlet.module.boss.BossModule;
import ca.gauntlet.module.maze.MazeModule;
import com.google.inject.Provides;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.events.VarbitChanged;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;

@PluginDescriptor(name="The Gauntlet", description="All-in-one plugin for The Gauntlet.", tags={"the", "gauntlet"})
public final class TheGauntletPlugin
extends Plugin {
    private static final int VARBIT_MAZE = 9178;
    private static final int VARBIT_BOSS = 9177;
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private MazeModule mazeModule;
    @Inject
    private BossModule bossModule;

    @Provides
    TheGauntletConfig provideConfig(ConfigManager configManager) {
        return configManager.getConfig(TheGauntletConfig.class);
    }

    @Override
    protected void startUp() {
        if (this.client.getGameState() != GameState.LOGGED_IN) {
            return;
        }
        this.clientThread.invoke(() -> {
            if (this.client.getVarbitValue(9177) == 1) {
                this.bossModule.start();
            } else if (this.client.getVarbitValue(9178) == 1) {
                this.mazeModule.start();
            }
        });
    }

    @Override
    protected void shutDown() {
        this.mazeModule.stop();
        this.bossModule.stop();
    }

    @Subscribe
    void onVarbitChanged(VarbitChanged event) {
        int varbit = event.getVarbitId();
        if (varbit == 9178) {
            if (event.getValue() == 1) {
                this.mazeModule.start();
            } else {
                this.mazeModule.stop();
            }
        } else if (varbit == 9177) {
            if (event.getValue() == 1) {
                this.mazeModule.stop();
                this.bossModule.start();
            } else {
                this.bossModule.stop();
            }
        }
    }
}

