/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.widget.scroll;

import java.awt.event.HierarchyListener;
import java.beans.PropertyChangeListener;
import javax.swing.JScrollPane;
import javax.swing.plaf.basic.ComboPopup;
import org.pushingpixels.substance.api.SubstanceWidget;
import org.pushingpixels.substance.api.painter.preview.PreviewPainter;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.WidgetUtilities;
import org.pushingpixels.substance.internal.widget.scroll.ScrollPaneSelector;

public class ScrollPaneSelectorWidget
extends SubstanceWidget<JScrollPane> {
    private ScrollPaneSelector scrollPaneSelector;
    private HierarchyListener hierarchyListener;
    private PropertyChangeListener propertyChangeListener;

    @Override
    public void installUI() {
        if (SubstanceCoreUtilities.toShowExtraWidgets(this.jcomp)) {
            PreviewPainter pPainter = WidgetUtilities.getComponentPreviewPainter(this.jcomp);
            if (pPainter == null) {
                return;
            }
            this.scrollPaneSelector = new ScrollPaneSelector();
            this.scrollPaneSelector.installOnScrollPane((JScrollPane)this.jcomp);
        }
    }

    @Override
    public void uninstallUI() {
        if (this.scrollPaneSelector != null) {
            this.scrollPaneSelector.uninstallFromScrollPane();
            this.scrollPaneSelector = null;
        }
    }

    @Override
    public void installListeners() {
        this.hierarchyListener = e -> {
            if (((JScrollPane)this.jcomp).getParent() instanceof ComboPopup && this.scrollPaneSelector != null) {
                this.scrollPaneSelector.uninstallFromScrollPane();
                this.scrollPaneSelector = null;
            }
        };
        ((JScrollPane)this.jcomp).addHierarchyListener(this.hierarchyListener);
        this.propertyChangeListener = evt -> {
            if ("substancelaf.internal.widget.componentPreviewPainter".equals(evt.getPropertyName())) {
                PreviewPainter pPainter = WidgetUtilities.getComponentPreviewPainter(this.jcomp);
                if (this.scrollPaneSelector != null) {
                    this.scrollPaneSelector.uninstallFromScrollPane();
                    this.scrollPaneSelector = null;
                }
                if (pPainter != null && SubstanceCoreUtilities.toShowExtraWidgets(this.jcomp)) {
                    this.scrollPaneSelector = new ScrollPaneSelector();
                    this.scrollPaneSelector.installOnScrollPane((JScrollPane)this.jcomp);
                }
            }
        };
        ((JScrollPane)this.jcomp).addPropertyChangeListener(this.propertyChangeListener);
    }

    @Override
    public void uninstallListeners() {
        ((JScrollPane)this.jcomp).removeHierarchyListener(this.hierarchyListener);
        this.hierarchyListener = null;
        ((JScrollPane)this.jcomp).removePropertyChangeListener(this.propertyChangeListener);
        this.propertyChangeListener = null;
    }
}

