/*
 * Decompiled with CFR 0.152.
 */
package org.pf4j.update;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import org.pf4j.PluginRuntimeException;
import org.pf4j.update.FileDownloader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleFileDownloader
implements FileDownloader {
    private static final Logger log = LoggerFactory.getLogger(SimpleFileDownloader.class);

    @Override
    public Path downloadFile(URL fileUrl) throws IOException {
        switch (fileUrl.getProtocol()) {
            case "http": 
            case "https": 
            case "ftp": {
                return this.downloadFileHttp(fileUrl);
            }
            case "file": {
                return this.copyLocalFile(fileUrl);
            }
        }
        throw new PluginRuntimeException("URL protocol {} not supported", fileUrl.getProtocol());
    }

    protected Path copyLocalFile(URL fileUrl) throws IOException {
        Path destination = Files.createTempDirectory("pf4j-update-downloader", new FileAttribute[0]);
        destination.toFile().deleteOnExit();
        try {
            Path fromFile = Paths.get(fileUrl.toURI());
            String path = fileUrl.getPath();
            String fileName = path.substring(path.lastIndexOf(47) + 1);
            Path toFile = destination.resolve(fileName);
            Files.copy(fromFile, toFile, StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
            return toFile;
        }
        catch (URISyntaxException e) {
            throw new PluginRuntimeException("Something wrong with given URL", new Object[]{e});
        }
    }

    protected Path downloadFileHttp(URL fileUrl) throws IOException {
        int length;
        Path destination = Files.createTempDirectory("pf4j-update-downloader", new FileAttribute[0]);
        destination.toFile().deleteOnExit();
        String path = fileUrl.getPath();
        String fileName = path.substring(path.lastIndexOf(47) + 1);
        Path file = destination.resolve(fileName);
        URLConnection connection = fileUrl.openConnection();
        connection.connect();
        HttpURLConnection httpConnection = (HttpURLConnection)connection;
        if (httpConnection.getResponseCode() == 401) {
            throw new ConnectException("HTTP Authorization failure");
        }
        long lastModified = httpConnection.getHeaderFieldDate("Last-Modified", System.currentTimeMillis());
        InputStream is = null;
        for (int i = 0; i < 3; ++i) {
            try {
                is = connection.getInputStream();
                break;
            }
            catch (IOException e) {
                log.error(e.getMessage(), e);
                continue;
            }
        }
        if (is == null) {
            throw new ConnectException("Can't get '" + fileUrl + " to '" + file + "'");
        }
        FileOutputStream fos = new FileOutputStream(file.toFile());
        byte[] buffer = new byte[1024];
        while ((length = is.read(buffer)) >= 0) {
            fos.write(buffer, 0, length);
        }
        fos.close();
        is.close();
        log.debug("Set last modified of '{}' to '{}'", (Object)file, (Object)lastModified);
        Files.setLastModifiedTime(file, FileTime.fromMillis(lastModified));
        return file;
    }
}

