/*
 * Decompiled with CFR 0.152.
 */
package com.zulrahhelper.ui;

import com.zulrahhelper.Phase;
import com.zulrahhelper.ZulrahHelperPlugin;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.util.ImageUtil;

public class ZulrahHelperPhasePanel
extends JPanel
implements MouseListener {
    private final ZulrahHelperPlugin plugin;
    private final Phase phase;
    private final JLabel picLabel;
    private final ImageIcon phaseIcon;
    private final ImageIcon phaseIconHover;

    ZulrahHelperPhasePanel(ZulrahHelperPlugin plugin, Phase phase, int columns) {
        this.plugin = plugin;
        this.phase = phase;
        BufferedImage img = this.processImg(phase.getImage(plugin.getConfig()), columns);
        this.phaseIcon = new ImageIcon(img);
        this.phaseIconHover = new ImageIcon(ImageUtil.luminanceScale(img, 0.75f));
        this.picLabel = new JLabel(this.phaseIcon);
        if (phase.isSelectable()) {
            this.picLabel.addMouseListener(this);
        }
        if (phase.isCurrent()) {
            this.setBorder(new LineBorder(ColorScheme.PROGRESS_COMPLETE_COLOR));
        }
        if (columns >= 2) {
            this.setBorder(new LineBorder(ColorScheme.PROGRESS_INPROGRESS_COLOR));
        }
        this.add(this.picLabel);
    }

    private BufferedImage processImg(BufferedImage img, int columns) {
        int size = 95;
        if (columns >= 3) {
            size = 60;
        }
        img = ImageUtil.resizeImage(img, size, size);
        if (this.phase.isCompleted()) {
            img = ImageUtil.luminanceScale(img, 0.4f);
        }
        return img;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.plugin.setState(this.phase);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.picLabel.setIcon(this.phaseIconHover);
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.picLabel.setIcon(this.phaseIcon);
    }
}

