/*
 * Decompiled with CFR 0.152.
 */
package ca.gauntlet;

import java.awt.Color;
import net.runelite.client.config.Alpha;
import net.runelite.client.config.Config;
import net.runelite.client.config.ConfigGroup;
import net.runelite.client.config.ConfigItem;
import net.runelite.client.config.ConfigSection;
import net.runelite.client.config.Range;
import net.runelite.client.config.Units;

@ConfigGroup(value="thegauntlet")
public interface TheGauntletConfig
extends Config {
    public static final String CONFIG_GROUP = "thegauntlet";
    @ConfigSection(name="Resource Tracking", description="Resource tracking section.", position=0, closedByDefault=true)
    public static final String resourceTrackingSection = "resourceTracking";
    @ConfigSection(name="Resource Overlay", description="Resource overlay section.", position=1, closedByDefault=true)
    public static final String resourceOverlaySection = "resourceOverlay";
    @ConfigSection(name="Utilities", description="Utilities section.", position=2, closedByDefault=true)
    public static final String utilitiesSection = "utilities";
    @ConfigSection(name="Npcs", description="Npcs section.", position=3, closedByDefault=true)
    public static final String npcsSection = "npcs";
    @ConfigSection(name="Hunllef", description="Hunllef section.", position=4, closedByDefault=true)
    public static final String hunllefSection = "hunllef";
    @ConfigSection(name="Timer", description="Timer section.", position=5, closedByDefault=true)
    public static final String timerSection = "timer";

    @ConfigItem(name="Track resources", description="Track resources in counter infoboxes.", position=0, keyName="resourceTracker", section="resourceTracking")
    default public boolean resourceTracker() {
        return false;
    }

    @ConfigItem(name="Tracking Mode", description="Increment or decrement resource counters.<br>Disable a counter by setting value to 0.", position=1, keyName="resourceTrackingMode", section="resourceTracking")
    default public TrackingMode resourceTrackingMode() {
        return TrackingMode.DECREMENT;
    }

    @ConfigItem(name="Remove acquired resources", description="Remove counters when acquired amount reached.", position=2, keyName="resourceRemoveAcquired", section="resourceTracking")
    default public boolean resourceRemoveAcquired() {
        return false;
    }

    @ConfigItem(name="Ore", description="The desired number of ores to acquire.", position=3, keyName="resourceOre", section="resourceTracking")
    default public int resourceOre() {
        return 3;
    }

    @ConfigItem(name="Phren bark", description="The desired number of phren barks to acquire.", position=4, keyName="resourceBark", section="resourceTracking")
    default public int resourceBark() {
        return 3;
    }

    @ConfigItem(name="Linum tirinum", description="The desired number of linum tirinums to acquire.", position=5, keyName="resourceTirinum", section="resourceTracking")
    default public int resourceTirinum() {
        return 3;
    }

    @ConfigItem(name="Grym leaf", description="The desired number of grym leaves to acquire.", position=6, keyName="resourceGrym", section="resourceTracking")
    default public int resourceGrym() {
        return 2;
    }

    @ConfigItem(name="Weapon frames", description="The desired number of weapon frames to acquire.", position=7, keyName="resourceFrame", section="resourceTracking")
    default public int resourceFrame() {
        return 2;
    }

    @ConfigItem(name="Paddlefish", description="The desired number of paddlefish to acquire.", position=8, keyName="resourcePaddlefish", section="resourceTracking")
    default public int resourcePaddlefish() {
        return 20;
    }

    @ConfigItem(name="Crystal shards", description="The desired number of crystal shards to acquire.", position=9, keyName="resourceShard", section="resourceTracking")
    default public int resourceShard() {
        return 320;
    }

    @ConfigItem(name="Bowstring", description="Whether or not to acquire the crystalline or corrupted bowstring.", position=10, keyName="resourceBowstring", section="resourceTracking")
    default public boolean resourceBowstring() {
        return false;
    }

    @ConfigItem(name="Spike", description="Whether or not to acquire the crystal or corrupted spike.", position=11, keyName="resourceSpike", section="resourceTracking")
    default public boolean resourceSpike() {
        return false;
    }

    @ConfigItem(name="Orb", description="Whether or not to acquire the crystal or corrupted orb.", position=12, keyName="resourceOrb", section="resourceTracking")
    default public boolean resourceOrb() {
        return false;
    }

    @ConfigItem(name="Overlay resources", description="Toggle enabling/disabling resource overlays.", position=0, keyName="overlayResources", section="resourceOverlay")
    default public boolean overlayResources() {
        return false;
    }

    @ConfigItem(name="Ore Deposit", description="Toggle overlaying ore deposits.", position=1, keyName="overlayOreDeposit", section="resourceOverlay")
    default public boolean overlayOreDeposit() {
        return true;
    }

    @Alpha
    @ConfigItem(name="Ore outline color", description="Change the outline color of ore deposits.", position=2, keyName="oreDepositOutlineColor", section="resourceOverlay")
    default public Color oreDepositOutlineColor() {
        return new Color(255, 0, 0, 255);
    }

    @Alpha
    @ConfigItem(name="Ore fill color", description="Change the fill color of ore deposits.", position=3, keyName="oreDepositFillColor", section="resourceOverlay")
    default public Color oreDepositFillColor() {
        return new Color(255, 0, 0, 50);
    }

    @ConfigItem(name="Phren Roots", description="Toggle overlaying phren roots.", position=4, keyName="overlayPhrenRoots", section="resourceOverlay")
    default public boolean overlayPhrenRoots() {
        return true;
    }

    @Alpha
    @ConfigItem(name="Phren outline color", description="Change the outline color of phren roots.", position=5, keyName="phrenRootsOutlineColor", section="resourceOverlay")
    default public Color phrenRootsOutlineColor() {
        return new Color(0, 255, 0, 255);
    }

    @Alpha
    @ConfigItem(name="Phren fill color", description="Change the fill color of phren roots.", position=6, keyName="phrenRootsFillColor", section="resourceOverlay")
    default public Color phrenRootsFillColor() {
        return new Color(0, 255, 0, 50);
    }

    @ConfigItem(name="Linum Tirinum", description="Toggle overlaying linum tirinum.", position=7, keyName="overlayLinumTirinum", section="resourceOverlay")
    default public boolean overlayLinumTirinum() {
        return true;
    }

    @Alpha
    @ConfigItem(name="Linum outline color", description="Change the outline color of linum tirinum.", position=8, keyName="linumTirinumOutlineColor", section="resourceOverlay")
    default public Color linumTirinumOutlineColor() {
        return new Color(255, 255, 255, 255);
    }

    @Alpha
    @ConfigItem(name="Linum fill color", description="Change the fill color of linum tirinum.", position=9, keyName="linumTirinumFillColor", section="resourceOverlay")
    default public Color linumTirinumFillColor() {
        return new Color(255, 255, 255, 50);
    }

    @ConfigItem(name="Grym Root", description="Toggle overlaying grym roots.", position=10, keyName="overlayGrymRoot", section="resourceOverlay")
    default public boolean overlayGrymRoot() {
        return true;
    }

    @Alpha
    @ConfigItem(name="Grym outline color", description="Change the outline color of grym roots.", position=11, keyName="grymRootOutlineColor", section="resourceOverlay")
    default public Color grymRootOutlineColor() {
        return new Color(255, 255, 0, 255);
    }

    @Alpha
    @ConfigItem(name="Grym fill color", description="Change the fill color of grym roots.", position=12, keyName="grymRootFillColor", section="resourceOverlay")
    default public Color grymRootFillColor() {
        return new Color(255, 255, 0, 50);
    }

    @ConfigItem(name="Fishing Spot", description="Toggle overlaying fishing spots.", position=13, keyName="overlayFishingSpot", section="resourceOverlay")
    default public boolean overlayFishingSpot() {
        return true;
    }

    @Alpha
    @ConfigItem(name="Fishing outline color", description="Change the outline color of fishing spots.", position=14, keyName="fishingSpotOutlineColor", section="resourceOverlay")
    default public Color fishingSpotOutlineColor() {
        return new Color(0, 255, 255, 255);
    }

    @Alpha
    @ConfigItem(name="Fishing fill color", description="Change the fill color of fishing spots.", position=15, keyName="fishingSpotFillColor", section="resourceOverlay")
    default public Color fishingSpotFillColor() {
        return new Color(0, 255, 255, 50);
    }

    @Range(max=64)
    @ConfigItem(name="Icon size", description="Change the size of the resource icons.<br>0px width = disabled", position=16, keyName="resourceIconSize", section="resourceOverlay")
    @Units(value="px")
    default public int resourceIconSize() {
        return 14;
    }

    @Range(max=2)
    @ConfigItem(name="Hull outline width", description="Change the width of the resource hull outline.<br>0px width = disabled", position=17, keyName="resourceHullOutlineWidth", section="resourceOverlay")
    @Units(value="px")
    default public int resourceHullOutlineWidth() {
        return 1;
    }

    @Range(max=2)
    @ConfigItem(name="Tile outline width", description="Change the width of the resource tile outline.<br>0px width = disabled", position=18, keyName="resourceTileOutlineWidth", section="resourceOverlay")
    @Units(value="px")
    default public int resourceTileOutlineWidth() {
        return 1;
    }

    @ConfigItem(name="Minimap overlays", description="Overlay the minimap with icons for resources.", position=19, keyName="minimapResourceOverlay", section="resourceOverlay")
    default public boolean minimapResourceOverlay() {
        return false;
    }

    @ConfigItem(name="Dynamically remove overlays", description="Remove overlays for acquired tracked resources.<br>Disabled if incrementally tracking resources.", position=20, keyName="resourceRemoveOutlineOnceAcquired", section="resourceOverlay")
    default public boolean resourceRemoveOutlineOnceAcquired() {
        return false;
    }

    @ConfigItem(name="Outline starting room utilities", description="Outline various utilities in the starting room.", position=0, keyName="utilitiesOutline", section="utilities")
    default public boolean utilitiesOutline() {
        return false;
    }

    @Range(min=1, max=2)
    @ConfigItem(name="Outline width", description="Change the width of the utilities outline.", position=1, keyName="utilitiesOutlineWidth", section="utilities")
    @Units(value="px")
    default public int utilitiesOutlineWidth() {
        return 1;
    }

    @Alpha
    @ConfigItem(name="Outline color", description="Change the color of the utilities outline.", position=2, keyName="utilitiesOutlineColor", section="utilities")
    default public Color utilitiesOutlineColor() {
        return Color.MAGENTA;
    }

    @ConfigItem(name="Prevent entry with uncooked fish", description="Removes \"Pass\" and \"Quick-Pass\" while carrying uncooked paddlefish.", position=3, keyName="utilitiesFishCheck", section="utilities")
    default public boolean utilitiesFishCheck() {
        return false;
    }

    @ConfigItem(name="Outline Hunllef tile", description="Outline the Hunllef's tile.", position=0, keyName="hunllefTileOutline", section="hunllef")
    default public boolean hunllefTileOutline() {
        return false;
    }

    @Range(min=1, max=2)
    @ConfigItem(name="Tile outline width", description="Change the width of the Hunllef's tile outline.", position=1, keyName="hunllefTileOutlineWidth", section="hunllef")
    @Units(value="px")
    default public int hunllefTileOutlineWidth() {
        return 1;
    }

    @Alpha
    @ConfigItem(name="Tile outline color", description="Change the outline color of the Hunllef's tile.", position=2, keyName="hunllefOutlineColor", section="hunllef")
    default public Color hunllefOutlineColor() {
        return Color.WHITE;
    }

    @Alpha
    @ConfigItem(name="Tile fill color", description="Change the fill color of the Hunllef's tile.", position=3, keyName="hunllefFillColor", section="hunllef")
    default public Color hunllefFillColor() {
        return new Color(255, 255, 255, 0);
    }

    @ConfigItem(name="Outline tornado tile", description="Outline the tiles of tornadoes.", position=4, keyName="tornadoTileOutline", section="hunllef")
    default public TileOutline tornadoTileOutline() {
        return TileOutline.OFF;
    }

    @Range(min=1, max=2)
    @ConfigItem(name="Tile outline width", description="Change tile outline width of tornadoes.", position=5, keyName="tornadoTileOutlineWidth", section="hunllef")
    @Units(value="px")
    default public int tornadoTileOutlineWidth() {
        return 1;
    }

    @Alpha
    @ConfigItem(name="Tile outline color", description="Color to outline the tile of a tornado.", position=6, keyName="tornadoOutlineColor", section="hunllef")
    default public Color tornadoOutlineColor() {
        return Color.YELLOW;
    }

    @Alpha
    @ConfigItem(name="Tile fill color", description="Color to fill the tile of a tornado.", position=7, keyName="tornadoFillColor", section="hunllef")
    default public Color tornadoFillColor() {
        return new Color(255, 255, 0, 50);
    }

    @ConfigItem(name="Outline demi-bosses", description="Overlay demi-bosses with a colored outline.", position=0, keyName="demibossOutline", section="npcs")
    default public boolean demibossOutline() {
        return false;
    }

    @Range(min=1, max=2)
    @ConfigItem(name="Outline width", description="Change the width of the demi-boss outline.", position=1, keyName="demibossOutlineWidth", section="npcs")
    @Units(value="px")
    default public int demibossOutlineWidth() {
        return 1;
    }

    @Alpha
    @ConfigItem(name="Dark beast color", description="Change the outline color of dark beasts.", position=2, keyName="darkBeastOutlineColor", section="npcs")
    default public Color darkBeastOutlineColor() {
        return Color.GREEN;
    }

    @Alpha
    @ConfigItem(name="Dragon color", description="Change the outline color of dragons.", position=3, keyName="dragonOutlineColor", section="npcs")
    default public Color dragonOutlineColor() {
        return Color.BLUE;
    }

    @Alpha
    @ConfigItem(name="Bear color", description="Change the outline color of bears.", position=4, keyName="bearOutlineColor", section="npcs")
    default public Color bearOutlineColor() {
        return Color.RED;
    }

    @ConfigItem(name="Outline strong npcs", description="Overlay strong npcs with a colored outline.", position=5, keyName="strongNpcOutline", section="npcs")
    default public boolean strongNpcOutline() {
        return false;
    }

    @Range(min=1, max=2)
    @ConfigItem(name="Outline width", description="Change the width of the strong npcs outline.", position=6, keyName="strongNpcOutlineWidth", section="npcs")
    @Units(value="px")
    default public int strongNpcOutlineWidth() {
        return 1;
    }

    @Alpha
    @ConfigItem(name="Outline color", description="Change the outline color of strong npcs.", position=7, keyName="strongNpcOutlineColor", section="npcs")
    default public Color strongNpcOutlineColor() {
        return Color.ORANGE;
    }

    @ConfigItem(name="Outline weak npcs", description="Overlay weak npcs with a colored outline.", position=8, keyName="weakNpcOutline", section="npcs")
    default public boolean weakNpcOutline() {
        return false;
    }

    @Range(min=1, max=2)
    @ConfigItem(name="Outline width", description="Change the width of the weak npcs outline.", position=9, keyName="weakNpcOutlineWidth", section="npcs")
    @Units(value="px")
    default public int weakNpcOutlineWidth() {
        return 1;
    }

    @Alpha
    @ConfigItem(name="Outline color", description="Change the outline color of weak npcs.", position=10, keyName="weakNpcOutlineColor", section="npcs")
    default public Color weakNpcOutlineColor() {
        return Color.ORANGE;
    }

    @ConfigItem(name="Minimap overlays", description="Overlay the minimap with icons for demi-bosses.", position=11, keyName="minimapDemibossOverlay", section="npcs")
    default public boolean minimapDemibossOverlay() {
        return false;
    }

    @ConfigItem(position=0, keyName="timerOverlay", name="Overlay timer", description="Display an overlay that tracks your gauntlet time.", section="timer")
    default public boolean timerOverlay() {
        return false;
    }

    @ConfigItem(position=1, keyName="timerChatMessage", name="Chat timer", description="Display a chat message on-death with your gauntlet time.", section="timer")
    default public boolean timerChatMessage() {
        return false;
    }

    public static enum TrackingMode {
        DECREMENT("Decrement"),
        INCREMENT("Increment");

        private final String name;

        public String toString() {
            return this.name;
        }

        public String getName() {
            return this.name;
        }

        private TrackingMode(String name) {
            this.name = name;
        }
    }

    public static enum TileOutline {
        OFF("Off"),
        ON("On"),
        TRUE_TILE("True Tile");

        private final String name;

        public String toString() {
            return this.name;
        }

        public String getName() {
            return this.name;
        }

        private TileOutline(String name) {
            this.name = name;
        }
    }
}

